#include <SoftwareSerial.h> 
#include <SPI.h> 
#include <Wire.h> 
#include <Adafruit_GFX.h> 
#include <Adafruit_SSD1306.h> 
#include "DHT.h"
#define SCREEN_WIDTH 128 // OLED 寬度像素
#define SCREEN_HEIGHT 64 // OLED 高度像素
#define DHTPIN 4 
#define DHTTYPE DHT11
DHT dht(DHTPIN, DHTTYPE);

#define OLED_RESET     -1 // Reset pin # (or -1 if sharing Arduino reset pin)
Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);


long pmat10 = 0;
int pmat25 = 0;
long pmat100 = 0;
unsigned int temperature = 0;
unsigned int humandity = 0;
int pmat25_value=0;
int s=0;
int tt=0;
int hh=0;
float h =0;
float t =0;
SoftwareSerial pmsSerial(2, 3); // 將Arduino Pin2設定為RX, Pin3設定為TX
 
 void testdrawstyles() {
  display.clearDisplay();
  display.setTextSize(1);          // 設定文字大小
  display.setTextColor(1);         // 1:OLED預設的顏色(這個會依該OLED的顏色來決定)
  
  
  display.setCursor(5,0);
  display.print("PM1.0=");
  display.setCursor(70,0);
  display.print(pmat10);
  display.setCursor(85,0);
  display.println(" ug/m3");

  display.setCursor(5,12);
  display.print("PM2.5=");
  display.setCursor(70,12);
  display.print(pmat25);
  display.setCursor(85,12);
  display.println(" ug/m3");

  display.setCursor(5,24);
  display.print("PM10=");
  display.setCursor(70,24);
  display.print(pmat100);
  display.setCursor(85,24);
  display.println(" ug/m3");

  display.setCursor(5,36);          // 設定起始座標
  display.print("Temp=");     // 要顯示的字串
  display.setCursor(70,36);        // 設定起始座標
  display.print(t);
  display.setCursor(95,36);
  display.println(" (C)");
  
  display.setCursor(5,48);          // 設定起始座標
  display.print("Humidity=");     // 要顯示的字串
  display.setCursor(70,48);        // 設定起始座標
  display.print(h);
  display.setCursor(95,48);
  display.println(" (%)");

  display.display();               // 要有這行才會把文字顯示出來
  delay(1000);
}

void pms5003t_spec(){
  int count = 0;
  unsigned char c;
  unsigned char high;
  while (pmsSerial.available()) { 
    c = pmsSerial.read();
    if((count==0 && c!=0x42) || (count==1 && c!=0x4d)){
      Serial.println("check failed");
      break;
    }
    if(count > 27){ 
      Serial.println("Done!!");
      break;
    }
     else if(count == 10 || count == 12 || count == 14 || count == 24 || count == 26) {
      high = c;
    }
    else if(count == 11){
      pmat10 = 256*high + c;
      Serial.print("PM1.0=");
      Serial.print(pmat10);
      Serial.println(" ug/m3");
    }
    else if(count == 13){
      pmat25 = 256*high + c;
      Serial.print("PM2.5=");
      Serial.print(pmat25);
      Serial.println(" ug/m3");
    }
    else if(count == 15){
      pmat100 = 256*high + c;
      Serial.print("PM10=");
      Serial.print(pmat100);
      Serial.println(" ug/m3");
    }
     else if(count == 25){        
      temperature = (256*high + c)/10;
      Serial.print("Temp=");
      Serial.print(temperature);
      Serial.println(" (C)"); 
    }
    else if(count == 27){            
      humandity = (256*high + c)/10;
      Serial.print("Humidity=");
      Serial.print(humandity);
      Serial.println(" (%)"); 
    }   
    count++;
  }
  while(pmsSerial.available()) 
    pmsSerial.read();
  Serial.println();
}
void dht11() {
    delay(1000);
  h = dht.readHumidity();   //取得濕度
  t = dht.readTemperature();  //取得溫度C

  //顯示在監控視窗裡
  Serial.print("Humidity: ");
  Serial.print(h);
  Serial.print(" %\t");
  Serial.print("Temperature: ");
  Serial.print(t);
  Serial.println(" *C ");
 
}
void setup()
{
  pmsSerial.begin(9600);
  Serial.begin(9600);
  dht.begin();
  if(!display.begin(SSD1306_SWITCHCAPVCC, 0x3C)) { // 一般1306 OLED的位址都是0x3C
    Serial.println(F("SSD1306 allocation failed"));
    for(;;); // Don't proceed, loop forever
  }
}

void loop(){
    for(int count = 0; count < 5; count++){
        pms5003t_spec();
      }
    dht11();
    //tt= (temperature+t)/2;
    //hh= (humandity+h)/2;
    //Serial.print(tt);
    //Serial.println(hh);
    testdrawstyles();
    display.clearDisplay();
    
    //delay(500);
}