#include <WiFi.h>
#include <WiFiUdp.h>
#include "DHT.h"
#define DHTPIN 10 
#define DHTTYPE DHT11
DHT dht(DHTPIN, DHTTYPE);
//請修改以下參數
//-------------------------------------------------------------------------------------------
char    szSSID[] = "---";         //Your_SSID
char    szPassword[] = "123456789"; //Your_Password
String  szLINEToken = "R3xv5FIOYxSgnbvTq4rCPs0HOw2ADFQbw0IhZkdpXdI"; //Your_LINE_Notify_Token
//-------------------------------------------------------------------------------------------

WiFiSSLClient client;

float fnUltraSonicDistance(int nTrigPin, int nEchoPin) 
{
    digitalWrite(nTrigPin, LOW);
    digitalWrite(nEchoPin, LOW);

    delayMicroseconds(5);
    digitalWrite(nTrigPin, HIGH);
    delayMicroseconds(10);
    digitalWrite(nTrigPin, LOW);
    unsigned long sonic_duration = pulseIn(nEchoPin, HIGH);
    float fDistanceCM = (sonic_duration / 2.0) / 29.1;
    return fDistanceCM;
}

void fnWiFiConnect()
{
    //連線到指定的WiFi szSSID
    Serial.print("Connecting Wifi: ");
    Serial.println(szSSID);
    WiFi.begin(szSSID, szPassword);
    while (WiFi.status() != WL_CONNECTED) { 
        Serial.print("."); 
        delay(300);
    };
    //連線成功，顯示取得的IP
    digitalWrite(3, LOW); 
    Serial.println("\nWiFi Connected!");
    Serial.print("IP address: ");
    IPAddress ip = WiFi.localIP();
    Serial.println(ip);
}

void setup() 
{
    pinMode(5, INPUT); 
    pinMode(8, OUTPUT); 
    Serial.begin(115200);
    pinMode(4, OUTPUT);
    pinMode(6, OUTPUT);
    pinMode(3, OUTPUT);
    pinMode(9, OUTPUT);
    pinMode(11,OUTPUT);
    pinMode(12,INPUT);
    pinMode(2,INPUT);
    digitalWrite(3, HIGH); 
    digitalWrite(9, HIGH); 
    Serial.println("DHTxx test!");
    dht.begin();  //初始化DHT
    fnWiFiConnect();
}
int dly=0;
int count2=0;
int a=0;
int b=0;
void loop() 
{

    if(WiFi.status() != WL_CONNECTED)
        fnWiFiConnect();

    float  fDistance=fnUltraSonicDistance(11, 12);
    //int buttonState = digitalRead(BUTTON_PIN);
    int sensor = digitalRead(5); 
    if (sensor == HIGH) {
      digitalWrite(8,HIGH);
      b=1;
      String ss="警告有易燃氣體\t";
      Serial.print("警告有易燃氣體\t");
      Serial.println(dly);
        if(dly==3000 && count2==0){
          dly=30;
          count2=1;
          line(ss,1,1);
        }
        else{  
        line(ss,0,1);
        }
    } 
    else {
      b=0;
      digitalWrite(8, LOW);
      Serial.print("安全\t");
    }
    
    float h = dht.readHumidity();   //取得濕度
    float t = dht.readTemperature();  //取得溫度C
    String s1 = "Humidity: ";
    String s2 = " %\t";
    String s3 = "Temperature: ";
    String s4 = " *C ";
    String s5 =s1 + h + s2 + s3 + t +s4;
    if(t>45){
        String s6 = "溫度過高!!危險!!";
        String ss = s5 + s6;
        Serial.print(ss);
        Serial.println(dly);
        if(dly==3000 && count2==0){
          dly=30;
          count2=1;
          line(ss,1,1);
        }
        else{  
        line(ss,0,1);
        }
    }
    else{
        a=0;
        dly=3000;
        String ss = s5;
        Serial.println(ss);
        //digitalWrite(6, LOW);
    }
    if(fDistance > 0 && fDistance < 20){
       digitalWrite(4, HIGH);
       String ss = s5;
        dly=3000;
        line(ss,0,0);
    }
    else { 
        digitalWrite(4, LOW);   // 沒人，關燈
       // Serial.print("沒有人\t");
    }
    if(digitalRead(2) == LOW ){
      digitalWrite(6 , HIGH);
      delay(10000);
      String ss = s5;
      dly=3000;
      line(ss,0,0);
    }
   delay(300);
   if(a+b>0){
      digitalWrite(6 , HIGH);
    }else{
      digitalWrite(6 , LOW);
    } 
   Serial.println(a+b);
}
void line(String s , int count , int relay)
{
    digitalWrite(3, HIGH);
    if(relay==1){
      digitalWrite(6, HIGH);
    }
    if((dly == 3000 && count==0 ) || (count==1 && count2==1)){
        count2=0;
        count=0;
        fnSendLINEMsg(s, szLINEToken);
        if(dly==3000){
          delay(3000);
        }
    }
    dly=dly-1;
    if(dly==0){
      dly=3000;
    }
    digitalWrite(3, LOW);
}
String URLEncode(const char* msg)
{
    const char *hex = "0123456789abcdef";
    String encodedMsg = "";
    while (*msg!='\0'){
        if(('a' <= *msg && *msg <= 'z')||('A' <= *msg && *msg <= 'Z')||('0' <= *msg && *msg <= '9')){
            encodedMsg += *msg;
        }else{
            encodedMsg += '%';
            encodedMsg += hex[*msg >> 4];
            encodedMsg += hex[*msg & 15];
        }
        msg++;
    }
    return encodedMsg;
}

void fnSendLINEMsg(String szLINEMsg, String szToken)
{
    WiFiSSLClient clientSecure;

    if (clientSecure.connect("notify-api.line.me",443)) {
        String data = "message="+URLEncode(szLINEMsg.c_str());
        
        clientSecure.println("POST /api/notify HTTP/1.1");
        clientSecure.println("Host: notify-api.line.me");
        clientSecure.println("Authorization: Bearer "+ szToken);
        clientSecure.println("Content-Type: application/x-www-form-urlencoded");
        clientSecure.print("Content-Length: ");
        clientSecure.println(data.length());
        clientSecure.println();
        clientSecure.println(data);
        clientSecure.stop();
    }
}