#if defined(ESP8266)
#include "ESP8266WiFi.h"
#else
#include <Arduino.h>
#include <WiFi.h>
#endif
#include <PubSubClient.h>

// Pin D0 (ESP8266) or Pin 13 (DSI5168) is the RELAY output pin
#if defined(ESP8266)
int relayPin = D0;  // RELAY
#elif defined(ESP32)
int relayPin = 26;  // RELAY
#else
int relayPin = 10;  // 若是 DSI5168 請修改成 13
#endif 



/* Set these to your desired credentials. */

char ssid2[] = "EricYangIoT";      // your network SSID (name)
char pass2[] = "66666666";      // your network password
char ssid1[] = "Pos";      // your network SSID (name)
char pass1[] = "0222435183";      // your network password
int status  = WL_IDLE_STATUS;    // the Wifi radio's status
//-----------------------------------------------------------------------------------------------------------
char mqttServer[]     = "broker.emqx.io";            // new ideaschain dashboard MQTT server
int mqttPort          = 1883;
char clientId[]       = "DSI5168TestXXXXXXX";        // it's better to use unique id.
char username[]       = "1234";                      // device access token(存取權杖)
char password[]       = "";                          // no need password

#define MQTT_USER               "my_name"             // unused
#define MQTT_PASSWORD           "my_password"         // unused
#define MQTT_RECONNECT_INTERVAL 100                   // millisecond
#define MQTT_LOOP_INTERVAL      50                    // millisecond

#define MQTT_SUBSCRIBE_ButtonR    "xxxxxx/ButtonR"       //訂閱 智能插座控制主題
#define MQTT_PUBLISH_ButtonT      "xxxxxx/ButtonT"       //發佈 智能插座狀態主題
#define MQTT_PUBLISH_ButtonTPIC   "xxxxxx/ButtonTPIC"    //發佈 智能插座狀態 url圖形
#define MQTT_PUBLISH_ButtonR      "xxxxxx/ButtonR"       //發佈 智能插座控制主題

#define MQTT_RECONNECT_INTERVAL 100                   // millisecond
#define MQTT_LOOP_INTERVAL      50                    // millisecond


unsigned long WifiConnectingTimeout; //連線逾時時間
unsigned long alarmTimeout;

void mqtt_callback(char* topic, byte* payload, unsigned int msgLength);  // MQTT Callback function header
WiFiClient wifiClient;
PubSubClient mqttClient(mqttServer, mqttPort, mqtt_callback, wifiClient);

String mqttValue;
long lastTime = 0 , startTime = 0;
String HomeDeviceButton ;
int keyStatus = 0;

boolean mqtt_nonblock_reconnect() {
  boolean doConn = false;

  if (! mqttClient.connected()) {
    // attempts to reconnect every [MQTT_RECONNECT_INTERVAL] milliseconds without blocking the main loop.
    long currTime = millis();
    if (currTime - lastTime > MQTT_RECONNECT_INTERVAL) {
      lastTime = currTime;
      doConn = true;
      boolean isConn = mqttClient.connect(clientId);
      //boolean isConn = mqttClient.connect(clientId, MQTT_USER, MQTT_PASSWORD);
      char logConnected[100];
      sprintf(logConnected, "HomeDevice [%s] Connect %s !", clientId, (isConn ? "Successful" : "Failed"));
      Serial.println(logConnected);

      if (isConn) {

        mqttClient.subscribe(MQTT_SUBSCRIBE_ButtonR);  //訂閱 智能插座控制主題

      }
    }
  }
  return doConn;
}

void mqtt_callback(char* topic, byte* payload, unsigned int msgLength) {

  char temp[80];
  sprintf(temp , "Message arrived with Topic [%s]\n  Data Length: [%d], Payload: [", topic, msgLength);
  Serial.print(temp);
  Serial.write(payload, msgLength);
  Serial.println("]");

  if (strcmp(MQTT_SUBSCRIBE_ButtonR, topic) == 0) {        //智能插座控制主題

    HomeDeviceButton = "";
    for (int i = 0; i < msgLength; i++) {
      HomeDeviceButton += (char)payload[i];
    }      //  Payload: [On]
    if ( HomeDeviceButton == "On" )
      digitalWrite(relayPin, HIGH);
    else
      digitalWrite(relayPin, LOW);
  }

}


void setup()
{
  Serial.begin(115200);


  pinMode(relayPin, OUTPUT);

  Serial.print("Configuring access point...");

  WifiConn();

  if ( WiFi.status() == WL_CONNECTED ) {
    Serial.println("waiting for sync");
    for (int i = 0 ; i < 3 ; i++)
    {

      digitalWrite(relayPin, HIGH);
      delay(500);
      digitalWrite(relayPin, LOW);
      delay(500);
    }

  }
  else
  {
    Serial.println("no network !!   ");

  }

  Serial.println(WiFi.localIP());
  Serial.println("Starting MQTT broker");
  mqtt_nonblock_reconnect();
}

int counter = 0;
bool portValue = 0 ;

void loop()
{
  mqtt_nonblock_reconnect();
  if ( digitalRead( relayPin) )    //讀取智能插座狀態
  {
    startTime = millis();
    mqttClient.publish(MQTT_PUBLISH_ButtonT, "On");  //送出 On 狀態
    mqttClient.publish(MQTT_PUBLISH_ButtonTPIC, "https://od.lk/s/MTVfMzAwMzA5NjNf/on4.png"); //送出 亮燈的 url圖檔連結
  }
  else
  {
    mqttClient.publish(MQTT_PUBLISH_ButtonT, "Off"); //送出 Off 狀態
    mqttClient.publish(MQTT_PUBLISH_ButtonTPIC, "https://od.lk/s/MTVfMzAwMzA5NjRf/off4.png"); //送出 關閉燈的 url圖檔連結
  }

  mqttClient.loop();
  delay(MQTT_LOOP_INTERVAL);
}

int WifiConn()
{
  Serial.print("Connecting to ");
  Serial.println(ssid1);

  /* Explicitly set the ESP8266 to be a WiFi-client, otherwise, it by default,
     would try to act as both a client and an access-point and could cause
     network-issues with your other WiFi-devices on your WiFi-network. */

  WiFi.begin(ssid1, pass1);
  WifiConnectingTimeout = millis();
  while (WiFi.status() != WL_CONNECTED) {
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(ssid1);
    // Connect to WPA/WPA2 network. Change this line if using open or WEP network:
    //WiFi.begin(ssid1, pass1);
    if ((millis() - WifiConnectingTimeout) > 10000) //等待 10秒
      break;
    delay(500);
    Serial.print(".");
  }
  if (WiFi.status() != WL_CONNECTED)
  {
    WifiConnectingTimeout = millis();
    WiFi.begin(ssid2, pass2);
    while (WiFi.status() != WL_CONNECTED) {
      Serial.print("Attempting to connect to SSID: ");
      Serial.println(ssid2);
      // Connect to WPA/WPA2 network. Change this line if using open or WEP network:

      if ((millis() - WifiConnectingTimeout) > 10000) //等待 10秒
        break;
      delay(500);
      Serial.print(".");
    }
  }

}
