"""
 LINE_Notify_IOT-M487.py
"""

from pyb import Switch
from pyb import Pin
from pyb import ADC,LED
import pyb
import network
import usocket as socket
import ussl as ssl
import math

# initialise variables
delayTime = 50000 # in Sekunden

SSID = "MYAP"            # 填入要連線的WiFi熱點名稱
PASSWORD = "19760106"    # Wi-Fi熱點密碼
HOST = "notify-api.line.me"       # 伺服器網址，不可動
PORT = 443
API_URL = "/api/notify"   # 連線對象URL，不可動
Linetoken = "****************************************"  # 資料平台裝置的存取權限碼
wlan = True
DEBUG = True
ledY = None
KeyDone1 = None
KeyDone2 = None

def calcTemp():
  global x, Val, Temperature, temp0
  Temperature = math.log(10000 * (4095 / Val - 1))
  Temperature = 1 / (0.001129148 + (0.000234125 + 8.76741e-8 * (Temperature * Temperature)) * Temperature)
  Temperature = Temperature - 273.15
  return Temperature

def wifi():                    # 連線到Wi-Fi熱點的定義函數
  global wlan
  try:
    print("connecting to wifi")
    wlan = network.WLAN()      # 設定Wi-Fi的連線類型為WLAN
    print("Wait connecting")
    wlan.connect(SSID, PASSWORD)   # 連線至Wi-Fi
    print(wlan.ifconfig())  # 印出分配到的 IP 位址
    print("Wi-Fi connect")

  except:
    print("Wifi module initial error, reconnecting......")
    pyb.delay(1000)     # 延遲1秒(=1000毫秒)
    wifi()              # 若連線失敗，則重新執行此函數

def data_update():
  try:
    Socket1 = socket.socket(socket.AF_INET, socket.SOCK_STREAM)  # Create STREAM TCP socket
    print("connecting to server")
    Socket1.connect(addr)          # 與伺服器進行連線
    print("server is connected")
    pyb.delay(1000)
    ssl_sock = ssl.wrap_socket(Socket1)    # SSL wrap
    ssl_sock.write(message_str)    # send data
    print("send done")
    pyb.delay(1000)
    Socket1.close()            # 關閉與伺服器的連線，避免佔用端口。
  except:
    print("except")
    pyb.delay(1000)

def key_int2():
  global KeyDone2
  KeyDone2 = True

def key_int3():
  global KeyDone3
  KeyDone3 = True

# Start Function
if __name__ == '__main__':
  # pyb.delay(5000)        # 延遲5秒(=5000毫秒)
  ledY = LED('led1') # create an LED object
  ledY.off()
  sw2 = Switch('sw2')   # create a switch object
  sw2.callback(key_int2) # register a callback to be called when the switch is pressed down
  sw3 = Switch('sw3')   # create a switch object
  sw3.callback(key_int3) # register a callback to be called when the switch is pressed down
  KeyDone2 = False
  KeyDone3 = False
  temp = ADC(Pin.board.A0)

  wifi()                  # 執行連線到Wi-Fi熱點
  print("--- Start ---")

  while True:
    if KeyDone2 == True:      #Press SW2
      print('SW2 press')
      ledY.on()
      tempt_val = temp.read()
      Val = 4095 - tempt_val
      temp0 = round(calcTemp())
      print ('Current temperature is:={:d}'.format(temp0))

      #  上傳訊息內容格式，其中key1為資料名稱(如溫度、濕度...等)，value1為資料內容(如28、66.5...等)
      param_data = "message=Temp: " + str(temp0) + "*C"

      # 定義發送至伺服器的訊息內容
      message_str = "POST " + API_URL + " HTTP/1.1\r\n" \
                  + "Host: " + HOST + "\r\n" \
                  + "Authorization: Bearer " + Linetoken + "\r\n" \
                  + "Content-Length: " + str(len(param_data)) + "\r\n" \
                  + "Content-Type: application/x-www-form-urlencoded\r\n\r\n" \
                  + param_data + "\r\n"

      addr = socket.getaddrinfo(HOST, PORT)[0][-1]  # 取得連線到伺服器的相關訊息
      print(addr)              # 顯示取得的address訊息內容
      data_update()            # 執行此函數
      print(message_str)       # 顯示此訊息內容進行debug
      ledY.off()
      KeyDone2 = False

    if KeyDone3 == True:      #Press SW3
      print('SW3 press')
      break
    # pyb.delay(delayTime)

  wlan.disconnect() # disassociate with wireless access point
  sw2.callback(None)
  sw3.callback(None)
  print('demo done')
