//
// Copyright (c) 2019/9/27 
// Author: Eric Yang
//
// Description :
//   Dust sensor - PMS5003T BH1750 PIR
//   Environment:
//     DSI5168 1.0
//     Arduino 1.8.10
//
// Connections :
//   PMS5003T    => Serial Port
//   LCD Module  => SDA SCL
//
// Required Library :
//   DFRobot_LCD BH1750 Conplug_PMS5003T TimeLib
//   TimeLib              https://github.com/PaulStoffregen/Time
//   DFRobot              https://github.com/bearwaterfall/DFRobot_LCD-master
//   Conplug_PMS5003T     https://github.com/Conplug/Conplug_PMS5003T
//   BH1750               https://github.com/claws/BH1750
//

#define LCM2004A_I2C_ADR1  ((uint8_t) 0x21)    // default PCF8574A I2C address
#define LCM2004A_I2C_ADR2 ((uint8_t) 0x20)    // alternative PCF8574 I2C address

#define LCM2004A_I2C_DB   ((uint8_t) 0b11110000)  // P7-P4: Four high order data bus pins
#define P7  ((uint8_t) 0b10000000)  // P7
#define P6  ((uint8_t) 0b01000000)  // P6
#define P5  ((uint8_t) 0b00100000)  // P5
#define P4  ((uint8_t) 0b00010000)  // P4
#define P3  ((uint8_t) 0b00001000)  // P3: LCD backlight
#define P2  ((uint8_t) 0b00000100)  // P2: Starts data read/write
#define P1  ((uint8_t) 0b00000010)  // P1: Selects Read/Write (1/0)
#define P0  ((uint8_t) 0b00000001)  // P0: Selects Instruction/Data register (0/1)


#include <WiFi.h>
#include <WiFiUdp.h>
#include <HttpClient.h>
#include <Wire.h>
#include <BH1750.h>
#include <TimeLib.h>
#include <ArduinoJson.h>
#include <LiquidCrystal_I2C.h>
#include "DFRobot_LCD.h"
#include "SoftwareSerial.h"
#include "DFRobotDFPlayerMini.h"
#include <RCSwitch.h>
#include "jm_PCF8574.h"

const String Project_AK = "xy31c3ESg4w7PPLH";       //IDEAS_chain 專案金鑰
const String GW_DID = "7535011528915384";           //IDEAS_chain 裝置編號
const String GW_SID_RFA = "QuarkSensor";            //IDEAS_chain QuarlSensor 感測器ID
const char* getRFAValue;                  //按照抓回的順序宣告


int status = WL_IDLE_STATUS;
char ssid2[] = "Pos";                                //  your network SSID (name)
char pass2[] = "0222435183";                         // your network password
char ssid1[] = "EricYang";
char pass1[] = "66666666";
WiFiClient client;
const char* iftttHost = "maker.ifttt.com";  //Ifttt主機
const char* eventName   = "msg2LINE";  //Ifttt觸發條件名稱
const char* key = "dOQDNJd1otLw8pUWs4YCF6Cd8mw7FJf0cgFiIKXdVUJ";  //Ifttt授權碼

//-------------------------------- NTP Server setup---------------------------------------------------------
int keyIndex = 0;                                   // your network key Index number (needed only for WEP)
int bootCounter = 0;                                // 統計 reset 次數
char timeServer[] = "time.stdtime.gov.tw";
const int timeZone = 8;                             // Taipei Time
// A UDP instance to let us send and receive packets over UDP
WiFiUDP Udp;
unsigned int localPort = 2390;                      // local port to listen for UDP packets
time_t getNtpTime();
void sendNTPpacket(IPAddress &address);
SoftwareSerial mySoftwareSerial(0, 1); // RX, TX
DFRobot_LCD lcd(16,2);
BH1750 lightMeter;  // 照度偵測器 宣告
RCSwitch mySwitch = RCSwitch();
DFRobotDFPlayerMini myDFPlayer;
jm_PCF8574 pcf8574(0x21);

void printDetail(uint8_t type, int value);

unsigned long startTime,quarkStartTime,nowTime;     // 程式起始時間與目前時間
unsigned long WifiConnectingTimeout; //連線逾時時間
int quarkLevel ;
int quarkFlag = 0;
int brightTime = 60 ;
float luxValue;                      // 照度
int alarmCounter = 0 ,gasAlarmCounter = 0;
int maxQuark = 0 ,lastMaxQuark = 0;
int msgAlarm3 = 0,msgAlarm4 = 0,msgAlarm5 = 0,msgAlarm6 = 0,msgAlarm7 = 0;
int alarmVoice = 0  , voiceNum;
int minLux = 15 ;

//------------------------------json6 object-------------------------------------------------------------
StaticJsonDocument<1024> doc;

void setup() {

    
   
   Serial.begin(9600);
   mySoftwareSerial.begin(9600);
      
   Serial.println("Connected to wifi");
   mySwitch.enableTransmit(10);  //RF 遙控
 

   
   pinMode(6,INPUT);   
   pinMode(2,INPUT);       // 3級偵測
   pinMode(11,INPUT);      // 4級偵測
   pinMode(12,INPUT);      // 5級偵測
   pinMode(13,OUTPUT);      // 燈光輸出
   
   pcf8574.pinMode( P0, INPUT );  // 6級偵測
   pcf8574.pinMode( P1, INPUT );  // 7級偵測
   
   Wire.begin();
   
   pcf8574.begin(); 
  
   lightMeter.begin();    // 照度感測器啟用 
   
   
   if (!myDFPlayer.begin(mySoftwareSerial)) {  //Use softwareSerial to communicate with mp3.
    Serial.println(F("Unable to begin:"));
    Serial.println(F("1.Please recheck the connection!"));
    Serial.println(F("2.Please insert the SD card!"));
    while(true){
      delay(0); // Code to compatible with ESP8266 watch dog.
    }
  }
  Serial.println(F("DFPlayer Mini online."));
  
  voiceNum = map(analogRead(A2), 1023, 295, 2, 30);
  myDFPlayer.volume(voiceNum);   
  myDFPlayer.play(8);     //系統設定中
  //myDFPlayer.enableLoopAll(); 
    

  lcd.init();            // 16 *2 LCD 初始化
  lcd.clear();           //清除LCD畫面

   if (WiFi.status() == WL_NO_SHIELD) {
    Serial.println("WiFi shield not present");
    // don't continue:
    while (true);
  }

  String fv = WiFi.firmwareVersion();
  if (fv != "1.1.0") {
    Serial.println("Please upgrade the firmware");
  }

  WifiConnectingTimeout = millis(); 
  while (status != WL_CONNECTED) {
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(ssid1);
    // Connect to WPA/WPA2 network. Change this line if using open or WEP network:
    status = WiFi.begin(ssid1, pass1);
    lcd.setCursor ( 0, 0 );        
    lcd.print("Connect ...");
    if((millis() - WifiConnectingTimeout) > 10000) //等待 10秒
        break;
    delay(3000);
  }
  while (status != WL_CONNECTED) {
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(ssid2);
    // Connect to WPA/WPA2 network. Change this line if using open or WEP network:
    status = WiFi.begin(ssid2, pass2);
    if((millis() - WifiConnectingTimeout) > 10000) //等待 10秒
        break; 

     // wait 3 seconds for connection:
    delay(3000);
  }
 
  
  lcd.setCursor ( 0, 0 ); 
  if ( status == WL_CONNECTED ){
       lcd.print("waiting for sync");
       Udp.begin(localPort);
       myDFPlayer.play(9);           //連線完成
  }
  else
  {
     lcd.print("no network !!   ");
     myDFPlayer.play(10);     //系統連線失敗
  }
  
  if(status == WL_CONNECTED )
  {
    setSyncProvider(getNtpTime);
    setSyncInterval(300);
  }
  delay(1000);
  
  pcf8574.digitalWrite( P0, LOW );

   
  startTime =  millis(); //設定程式開始執行的時間
  
}

void loop() {

  char runTime[7],realTimeStr[9];
  char luxStr[5],volStr[3];
  int counter;
  
  delay(500);
  
  lcd.setCursor ( 0, 0 );          
  lcd.print("Quake Level: "); 
  lcd.setCursor ( 14, 0 );
  lcd.print(" ");
  
  Serial.print("P2=");
  Serial.println( pcf8574.digitalRead(P2) );
  Serial.print("P0=");
  Serial.println( pcf8574.digitalRead(P0) );
  Serial.print("P1=");
  Serial.println( pcf8574.digitalRead(P1) );
  Serial.print("D6=");
  Serial.println( digitalRead(6) );  
  Serial.print("voiceNum = ");
  voiceNum = map(analogRead(A2), 1023, 295, 0, 30);
  myDFPlayer.volume(voiceNum);
  Serial.println( voiceNum );
  lcd.setCursor ( 14, 1 );
  sprintf(volStr,"%02d",(int)voiceNum);
  lcd.print(volStr);
  lcd.setCursor ( 0, 1 );
  sprintf(realTimeStr,"%02d:%02d:%02d",hour(),minute(),second());
  lcd.print(realTimeStr);
  luxValue = lightMeter.readLightLevel();    //讀取 光度 呈現於 LCD
  lcd.setCursor ( 9, 1 );
  sprintf(luxStr,"%-4d",(int)luxValue);
  lcd.print(luxStr);  
    
  if( digitalRead(2) == HIGH )
  {

        quarkLevel = 3 ;
        if( quarkLevel > maxQuark )
        {
          quarkStartTime = millis();
          maxQuark = quarkLevel ;
          lastMaxQuark = quarkLevel ;
        }
        
  }   
  if( digitalRead(11) == HIGH)
  {

       quarkLevel = 4 ;
        if( quarkLevel > maxQuark )
        {
          quarkStartTime = millis();
          maxQuark = quarkLevel ;
          lastMaxQuark = quarkLevel ;
        }
       

  }
  if( digitalRead(12) == HIGH)
  {

       quarkLevel = 5 ;
        if( quarkLevel > maxQuark )
        {
          quarkStartTime = millis();
          maxQuark = quarkLevel ;
          lastMaxQuark = quarkLevel ;
        }
       


  }  
  if( pcf8574.digitalRead(P0) == HIGH)
  {
 
       quarkLevel = 6 ;
        if( quarkLevel > maxQuark )
        {
          quarkStartTime = millis();
          maxQuark = quarkLevel ;
          lastMaxQuark = quarkLevel ;
        }

  }      
  if( pcf8574.digitalRead(P1) == HIGH)
  {
       quarkLevel = 7 ;
        if( quarkLevel > maxQuark )
        {
          quarkStartTime = millis();
          maxQuark = quarkLevel ;
          lastMaxQuark = quarkLevel ;
        }
  }      
  lcd.setCursor ( 13, 0 );
  lcd.print(maxQuark); 
  lcd.setCursor ( 15, 0 );
  lcd.print(lastMaxQuark);
    
  switch( maxQuark )
  {
     case 3:
            if( !msgAlarm3)
            {
               myDFPlayer.play(5);
               if(status == WL_CONNECTED )
               {
                 msgToIFTTT("3%20%E7%B4%9A%E5%9C%B0%E9%9C%87%2C%E8%AB%8B%E5%B0%8F%E5%BF%83%21%21");
                 post(GW_DID,Project_AK,GW_SID_RFA,"3");
               }
               msgAlarm3 = 1 ;
               alarmVoice = 0;
               
            }   
            break;
     case 4:
            if( !msgAlarm4)
            {
               myDFPlayer.play(4);
               if(status == WL_CONNECTED )
               {
                  msgToIFTTT("4%20%E7%B4%9A%E5%9C%B0%E9%9C%87%2C%E8%AB%8B%E5%B0%8F%E5%BF%83%21%21");
                  post(GW_DID,Project_AK,GW_SID_RFA,"4");
               }
               msgAlarm4 = 1 ;
               alarmVoice = 0;
               
               
               
            }
            break;            
     case 5:
            if( !msgAlarm5)
            {
               myDFPlayer.play(3);
               if(status == WL_CONNECTED )
               {
                 msgToIFTTT("5%20%E7%B4%9A%E5%BC%B7%E7%83%88%5C%E5%9C%B0%E9%9C%87%2C%E8%AB%8B%E8%87%A5%E4%B8%8B%20%E6%8A%B1%E9%A0%AD%20%E9%9D%A0%E7%89%86%E8%A7%92%21%21");
                 post(GW_DID,Project_AK,GW_SID_RFA,"5");
               }
               msgAlarm5 = 1 ;
               alarmVoice = 0;
               
               
            }
            break;
     case 6:
            if( !msgAlarm6)
            {
               myDFPlayer.play(2);
               if(status == WL_CONNECTED )
               {
                 msgToIFTTT("6%20%E7%B4%9A%E5%BC%B7%E7%83%88%5C%E5%9C%B0%E9%9C%87%2C%E8%AB%8B%E8%87%A5%E4%B8%8B%20%E6%8A%B1%E9%A0%AD%20%E9%9D%A0%E7%89%86%E8%A7%92%21%21");
                 post(GW_DID,Project_AK,GW_SID_RFA,"6");
               }
               msgAlarm6 = 1 ;
               alarmVoice = 0; 
               
               
            }
            break;
     case 7:
            if( !msgAlarm7)
            {
               myDFPlayer.play(11);
               if(status == WL_CONNECTED )
               {
                 msgToIFTTT("7%20%E7%B4%9A%E8%B6%85%E7%B4%9A%E5%BC%B7%E7%83%88%E5%9C%B0%E9%9C%87%2C%E8%AB%8B%E8%87%A5%E4%B8%8B%20%E6%8A%B1%E9%A0%AD%20%E9%9D%A0%E7%89%86%E8%A7%92%2C%E7%A5%88%E6%B1%82%E8%80%81%E5%A4%A9%E7%88%BA%E4%BF%9D%E4%BD%91%E4%BA%86~");
                 post(GW_DID,Project_AK,GW_SID_RFA,"7");
               }
               msgAlarm7 = 1 ;
               alarmVoice = 0;
               //myDFPlayer.play(2);
            }
            break;
  }
  
  if( maxQuark >= 3)
  {
     if( (((millis() - quarkStartTime) /1000) > 10 ) &&  !alarmVoice) 
     {
        myDFPlayer.play(7);
        alarmVoice = 1;
     }   
  }  
  if( maxQuark >= 4 )
    if( (int)luxValue < minLux )
       digitalWrite(13,HIGH);
    else
       digitalWrite(13,LOW);
       
  if( maxQuark >= 4 && !gasAlarmCounter) 
  {
      
     for(counter = 0; counter< 2 ; counter++ ) 
     {
        mySwitch.send("101111000110101010110010");
        if(counter==0)
          Serial.println("Close Gas");
        delay(50);
     }  
     if(status == WL_CONNECTED )    
       msgToIFTTT("%E9%81%BF%E5%85%8D%E5%8D%B1%E9%9A%AA%2C%E5%A4%A9%E7%84%B6%E7%93%A6%E6%96%AF%E5%B7%B2%E9%97%9C%E9%96%89%21%21");
     Serial.println("Level 5-7");
     gasAlarmCounter = 1;
  }  
  /*else
  {
    digitalWrite(6,LOW);  
     if( gasAlarmCounter )
     {
       for(counter = 0; counter< 11 ; counter++ ) 
       {
          mySwitch.send("111000000000010110001000");
          if(counter==0)
            Serial.println("Open Gas");
          delay(50);
       }
     } 
     gasAlarmCounter = 0;       
    //msgToIFTTT("7%20%E7%B4%9A%E8%B6%85%E7%B4%9A%E5%BC%B7%E7%83%88%E5%9C%B0%E9%9C%87%2C%E8%AB%8B%E8%87%A5%E4%B8%8B%20%E6%8A%B1%E9%A0%AD%20%E9%9D%A0%E7%89%86%E8%A7%92%2C%E7%A5%88%E6%B1%82%E8%80%81%E5%A4%A9%E7%88%BA%E4%BF%9D%E4%BD%91%E4%BA%86~");
  }*/
  Serial.println(( millis()- quarkStartTime) / 1000);
  if(((( millis()- quarkStartTime) / 1000) > brightTime) )
  {
     if(maxQuark > 3)
     {
       digitalWrite(13,LOW);
       quarkStartTime = millis();
       myDFPlayer.play(1);
       for(counter = 0; counter< 2 ; counter++ ) 
       {
          mySwitch.send("101111000110101010111000");
          if(counter==0)
            Serial.println("Open Gas");
          delay(50);
       }
       if(status == WL_CONNECTED )
       {
         msgToIFTTT("%E5%9C%B0%E9%9C%87%E8%AD%A6%E5%A0%B1%E8%A7%A3%E9%99%A4");
         post(GW_DID,Project_AK,GW_SID_RFA,"0");
       }
     }
     quarkLevel = 0 ; 
     maxQuark = 0;
     alarmCounter = 0;     
     msgAlarm3 = 0;
     msgAlarm4 = 0;
     msgAlarm5 = 0;
     msgAlarm6 = 0;
     msgAlarm7 = 0;
     gasAlarmCounter = 0;
     
  }
  if((((( millis()- startTime) / 1000) % 60 ) == 0 ) && ( maxQuark == 0 ))  //每分鐘傳回 0 級 震度
    post(GW_DID,Project_AK,GW_SID_RFA,"0"); 

  if( (maxQuark == 0 ) && ((digitalRead(6) == LOW ) || (pcf8574.digitalRead(P2) == 1)))  //當地震平靜且按下平安按鈕(低電位觸發)時
  {
    myDFPlayer.play(12);
    if(status == WL_CONNECTED )
      msgToIFTTT("%E5%9C%B0%E9%9C%87%E5%B7%B2%E5%B9%B3%E9%9D%9C%E4%B8%8B%E4%BE%86%E4%BA%86%2C%E6%88%91%E7%9B%AE%E5%89%8D%E5%B9%B3%E5%AE%89%E7%84%A1%E4%BA%8B%2C%E8%AB%8B%E5%88%A5%E6%93%94%E5%BF%83~");
  }  
} 
 
/*-------- NTP code ----------*/

const int NTP_PACKET_SIZE = 48; // NTP time is in the first 48 bytes of message
byte packetBuffer[NTP_PACKET_SIZE]; //buffer to hold incoming & outgoing packets

time_t getNtpTime()
{
  Serial.println("Transmit NTP Request");
  Udp.setRecvTimeout(1500);
  sendNTPpacket();
  if ( Udp.read(packetBuffer, NTP_PACKET_SIZE) > 0 ) {
      unsigned long secsSince1900;
      // convert four bytes starting at location 40 to a long integer
      secsSince1900 =  (unsigned long)packetBuffer[40] << 24;
      secsSince1900 |= (unsigned long)packetBuffer[41] << 16;
      secsSince1900 |= (unsigned long)packetBuffer[42] << 8;
      secsSince1900 |= (unsigned long)packetBuffer[43];
      return secsSince1900 - 2208988800UL + timeZone * SECS_PER_HOUR;
  } else {
    Serial.println("No NTP Response :-(");
    //myDFPlayer.play(10);     //系統連線失敗
    return 0; // return 0 if unable to get the time
  }
}

// send an NTP request to the time server at the given address
void sendNTPpacket()
{
  // set all bytes in the buffer to 0
  memset(packetBuffer, 0, NTP_PACKET_SIZE);
  // Initialize values needed to form NTP request
  // (see URL above for details on the packets)
  packetBuffer[0] = 0b11100011;   // LI, Version, Mode
  packetBuffer[1] = 0;     // Stratum, or type of clock
  packetBuffer[2] = 6;     // Polling Interval
  packetBuffer[3] = 0xEC;  // Peer Clock Precision
  // 8 bytes of zero for Root Delay & Root Dispersion
  packetBuffer[12]  = 49;
  packetBuffer[13]  = 0x4E;
  packetBuffer[14]  = 49;
  packetBuffer[15]  = 52;
  // all NTP fields have been given values, now
  // you can send a packet requesting a timestamp:                 
  Udp.beginPacket(timeServer, 123); //NTP requests are to port 123
  Udp.write(packetBuffer, NTP_PACKET_SIZE);
  Udp.endPacket();
}

void msgToIFTTT(String msgStr)
{
   client.stop();
   if (!client.connect(iftttHost, 80)) {
     Serial.println("connection failed");
     return;
   }
 
     String url = "/trigger/";  //組合觸發網址
     url += eventName;
     url += "/with/key/";
     url += key;
     url += "?value1=";
     url += msgStr;
     Serial.print("Requesting URL: ");
     Serial.println(url);
     
     client.print(String("GET ") + url + " HTTP/1.1\r\n" +
                  "Host: " + iftttHost + "\r\n" + 
                  "Connection: close\r\n\r\n");
     int timeout = millis() + 5000;
     while (client.available() == 0) {
       if (timeout - millis() < 0) {
         Serial.println("Client Timeout !");
         client.stop();
         //myDFPlayer.play(10);     //系統連線失敗
         return;
       }
     }
     
     while(client.available()){  //顯示回應訊息
       String line = client.readStringUntil('\r');
       Serial.print(line);
     }
   
}

void printDetail(uint8_t type, int value){
  switch (type) {
    case TimeOut:
      Serial.println(F("Time Out!"));
      break;
    case WrongStack:
      Serial.println(F("Stack Wrong!"));
      break;
    case DFPlayerCardInserted:
      Serial.println(F("Card Inserted!"));
      break;
    case DFPlayerCardRemoved:
      Serial.println(F("Card Removed!"));
      break;
    case DFPlayerCardOnline:
      Serial.println(F("Card Online!"));
      break;
    case DFPlayerUSBInserted:
      Serial.println("USB Inserted!");
      break;
    case DFPlayerUSBRemoved:
      Serial.println("USB Removed!");
      break;
    case DFPlayerPlayFinished:
      Serial.print(F("Number:"));
      Serial.print(value);
      Serial.println(F(" Play Finished!"));
      break;
    case DFPlayerError:
      Serial.print(F("DFPlayerError:"));
      switch (value) {
        case Busy:
          Serial.println(F("Card not found"));
          break;
        case Sleeping:
          Serial.println(F("Sleeping"));
          break;
        case SerialWrongStack:
          Serial.println(F("Get Wrong Stack"));
          break;
        case CheckSumNotMatch:
          Serial.println(F("Check Sum Not Match"));
          break;
        case FileIndexOut:
          Serial.println(F("File Index Out of Bound"));
          break;
        case FileMismatch:
          Serial.println(F("Cannot Find File"));
          break;
        case Advertise:
          Serial.println(F("In Advertise"));
          break;
        default:
          break;
      }
      break;
    default:
      break;
  }
  
}

void post(String IDEASCHAIN_DID, String IDEASCHAIN_AK, String IDEASCHAIN_SID, String value){  //  ��ƤW�ǥ��x
 client.stop();
 if (client.connect("ideaschain.com.tw", 80)) {
    client.print("POST /iot/v1/rawdata/");
    client.print(IDEASCHAIN_DID);
    client.println(" HTTP/1.1");
    client.println("Host: ideaschain.com.tw");
    client.print("AK: ");
    client.println(IDEASCHAIN_AK);    
    client.println("Content-Type: application/json");  ;
    client.print("Content-Length: ");
    client.println(IDEASCHAIN_SID.length()+value.length()+25);
    client.println();
    client.print("[{\"sid\":\"");
    client.print(IDEASCHAIN_SID);
    client.print("\",\"value\":[\"");
    client.print(value);
    client.println("\"]}]");
    } else {
      Serial.println();
      Serial.println("disconnecting from server.");
      //myDFPlayer.play(10);     //系統連線失敗
    }
    delay(500);
    Serial.println("sendData end");
}

 
void getJsonData(String IDEASCHAIN_DID, String IDEASCHAIN_AK){  //  資料下載
  
 String jsonTmp ; 
 client.stop();
 
 if (client.connect("ideaschain.com.tw", 80)) {
  // We now create a URI for the request
      String url = "/iot/v1/rawdata/" + IDEASCHAIN_DID;
      // This will send the request to the server
      client.print("GET " + url + " HTTP/1.1\r\n" +
                   "Host: " + "ideaschain.com.tw" + "\r\n" +
                   "AK:"+ IDEASCHAIN_AK + "\r\n" +
                   "Content-Type: application/json\r\n" + 
                   "Connection: close\r\n\r\n");
      delay(500);
    //取資料印出來
      while(client.available())
      {
        while(client.available()) {
          char c = client.read();
          while( c == '[' ){
            while (client.available()) {
              c = client.read();
              jsonTmp += c;
            }
          }
        }
      String jsonData = '[' + jsonTmp;
      
      Serial.println(jsonData); 
      DeserializationError error = deserializeJson(doc, jsonData);

      // Test if parsing succeeds.
       if (error) {
         Serial.print(F("deserializeJson() failed: "));
         Serial.println(error.c_str());
         return;
        }
       JsonArray array = doc.as<JsonArray>();
       for(JsonVariant v : array) {
         //Serial.println(v.as<int>());
          const char* sid2 = v["sid"];
          double value2 = v["value"][0];
          Serial.print(sid2);
          Serial.print("=");
          Serial.println(value2);
        }      
        
          getRFAValue = doc[0]["value"][0];

      }

    } else {
      Serial.println();
      Serial.println("disconnecting from server.");
      //myDFPlayer.play(10);     //系統連線失敗
    }
    
    Serial.println("getJsonData end");
   // return value;
}
