//
// Copyright (c) 2019/9/27 
// Author: Eric Yang
//
// Description :
//   Dust sensor - PMS5003T BH1750 PIR
//   Environment:
//     DSI5168 1.0
//     Arduino 1.8.10
//
// Connections :
//   PMS5003T    => Serial Port
//   LCD Module  => SDA SCL
//


#define LCM2004A_I2C_ADR1  ((uint8_t) 0x21)    // default PCF8574A I2C address
#define LCM2004A_I2C_ADR2 ((uint8_t) 0x20)    // alternative PCF8574 I2C address

#define LCM2004A_I2C_DB   ((uint8_t) 0b11110000)  // P7-P4: Four high order data bus pins
#define P7  ((uint8_t) 0b10000000)  // P7
#define P6  ((uint8_t) 0b01000000)  // P6
#define P5  ((uint8_t) 0b00100000)  // P5
#define P4  ((uint8_t) 0b00010000)  // P4
#define P3  ((uint8_t) 0b00001000)  // P3: LCD backlight
#define P2  ((uint8_t) 0b00000100)  // P2: Starts data read/write
#define P1  ((uint8_t) 0b00000010)  // P1: Selects Read/Write (1/0)
#define P0  ((uint8_t) 0b00000001)  // P0: Selects Instruction/Data register (0/1)


#include <WiFi.h>
#include <WiFiUdp.h>
#include <HttpClient.h>
#include <Wire.h>
#include <BH1750.h>
#include <TimeLib.h>
#include <ArduinoJson.h>
#include <LiquidCrystal_I2C.h>
#include "DFRobot_LCD.h"
#include "SoftwareSerial.h"
#include "wiring_watchdog.h"
#include "DFRobotDFPlayerMini.h"
#include <RCSwitch.h>
#include <jm_PCF8574.h>
#include <FlashMemory.h>

const String Project_AK = "xy31c3ESg4w7PPLH";       //IDEAS_chain 專案金鑰
const String GW_DID = "7535011528915384";           //IDEAS_chain 裝置編號
const String GW_SID_RFA = "QuarkSensor";            //IDEAS_chain QuarlSensor 感測器ID
const char* getRFAValue;                  //按照抓回的順序宣告


int status = WL_IDLE_STATUS;
char ssid1[] = "Pos";                                //  your network SSID (name)
char pass1[] = "0222435183";                         // your network password
char ssid2[] = "EricYang";
char pass2[] = "66666666";
WiFiClient client;
const char* iftttHost = "maker.ifttt.com";  //Ifttt主機
const char* eventName   = "msg2LINE";  //Ifttt觸發條件名稱
const char* key = "dOQDNJd1otLw8pUWs4YCF6Cd8mw7FJf0cgFiIKXdVUJ";  //Ifttt授權碼

//-------------------------------- NTP Server setup---------------------------------------------------------
int keyIndex = 0;                                   // your network key Index number (needed only for WEP)
int bootCounter = 0;                                // 統計 reset 次數
char timeServer[] = "time.stdtime.gov.tw";
const int timeZone = 8;                             // Taipei Time
// A UDP instance to let us send and receive packets over UDP
WiFiUDP Udp;
unsigned int localPort = 2390;                      // local port to listen for UDP packets
time_t getNtpTime();
void sendNTPpacket(IPAddress &address);
SoftwareSerial mySoftwareSerial(0, 1); // RX, TX
DFRobot_LCD lcd(16,2);

RCSwitch mySwitch = RCSwitch();
DFRobotDFPlayerMini myDFPlayer;
jm_PCF8574 pcf8574; // I2C address fixed later by begin(...)

void printDetail(uint8_t type, int value);

unsigned long startTime,quarkStartTime,nowTime;     // 程式起始時間與目前時間
unsigned long WifiConnectingTimeout; //連線逾時時間
int quarkLevel ;
int quarkFlag = 0;
int brightTime = 60 ;
float luxValue;                      // 照度
int alarmCounter = 0 ,gasAlarmCounter = 0;
int maxQuark = 0;
int msgAlarm3 = 0,msgAlarm4 = 0,msgAlarm5 = 0,msgAlarm6 = 0,msgAlarm7 = 0;
int alarmVoice = 0  , voiceNum;
int minLux = 15 ;
char now_Str[7];
String lastPressTimeStr ;
char dayType = '1',dayTypeR ='1';
int dayTypeDIP1,dayTypeDIP2,dayTypeDIP3,dayTypeDIP4;
int currentMp3 = 2 ,playKey = 0 ,playCounter =1,playMp3Flag = 0 ;

//------------------------------json6 object-------------------------------------------------------------
StaticJsonDocument<1024> doc;

void setup() {

    
   
   Serial.begin(9600);
   mySoftwareSerial.begin(9600);
      
   Serial.println("Connected to wifi");
   mySwitch.enableTransmit(10);  //RF 遙控
 

   
   pinMode(6,INPUT);   
   pinMode(2,INPUT);
   pinMode(10,INPUT);       
   pinMode(11,INPUT);      
   pinMode(12,INPUT);      
   pinMode(13,INPUT); 
   pinMode(A2,INPUT);     
   
   pcf8574.pinMode( P0, INPUT );  // 綠色按鈕
   pcf8574.pinMode( P1, INPUT );  // 黃色按鈕
   pcf8574.pinMode( P2, INPUT );  // 紅色按鈕
   
   dayTypeDIP1 = digitalRead(10);    //設定早上提醒
   dayTypeDIP2 = digitalRead(11);    //設定中午提醒
   dayTypeDIP3 = digitalRead(12);    //設定晚上提醒
   dayTypeDIP4 = digitalRead(13);    //設定睡前提醒
      
   Wire.begin();
   
   if (!pcf8574.begin(LCM2004A_I2C_ADR1))   //用板上JUMP調整位址
   {
     pcf8574.begin(LCM2004A_I2C_ADR2);
     Serial.println("Adress 0x20");
   }
   Serial.println("Adress 0x21");   
   
   
   
   if (!myDFPlayer.begin(mySoftwareSerial)) {  //Use softwareSerial to communicate with mp3.
    Serial.println(F("Unable to begin:"));
    Serial.println(F("1.Please recheck the connection!"));
    Serial.println(F("2.Please insert the SD card!"));
    while(true){
      delay(0); // Code to compatible with ESP8266 watch dog.
    }
  }
  Serial.println(F("DFPlayer Mini online."));
  
  myDFPlayer.EQ(DFPLAYER_EQ_ROCK);
  voiceNum = map(analogRead(A2), 137, 1023, 0, 30);
  myDFPlayer.volume(voiceNum);  
  myDFPlayer.playMp3Folder(1);     //系統設定中
  //myDFPlayer.enableLoopAll(); 
    

  lcd.init();            // 16 *2 LCD 初始化
  lcd.clear();           //清除LCD畫面

   if (WiFi.status() == WL_NO_SHIELD) {
    Serial.println("WiFi shield not present");
    // don't continue:
    while (true);
  }

  String fv = WiFi.firmwareVersion();
  if (fv != "1.1.0") {
    Serial.println("Please upgrade the firmware");
  }

  WifiConnectingTimeout = millis(); 
  while (status != WL_CONNECTED) {
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(ssid1);
    // Connect to WPA/WPA2 network. Change this line if using open or WEP network:
    status = WiFi.begin(ssid1, pass1);
    lcd.setCursor ( 0, 0 );        
    lcd.print("Connect ...");
    if((millis() - WifiConnectingTimeout) > 10000) //等待 10秒
        break; 
     // wait 3 seconds for connection:
    delay(500);
  }
  while (status != WL_CONNECTED) {
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(ssid2);
    // Connect to WPA/WPA2 network. Change this line if using open or WEP network:
    status = WiFi.begin(ssid2, pass2);
    if((millis() - WifiConnectingTimeout) > 10000) //等待 10秒
        break; 

     // wait 3 seconds for connection:
    delay(500);
  }
 
  
  lcd.setCursor ( 0, 0 ); 
  if ( status == WL_CONNECTED ){
       lcd.print("waiting for sync");
       Udp.begin(localPort);
       myDFPlayer.playMp3Folder(2);           //MP3資料夾下的 0002.mp3 連線完成
  }
  else
  {
     lcd.print("no network !!   ");
     myDFPlayer.playMp3Folder(3);    //MP3資料夾下的 0003.mp3  系統連線失敗
  }
  
  if(status == WL_CONNECTED )
  {
    setSyncProvider(getNtpTime);
    setSyncInterval(300);
  }
  delay(1000);
  
  

  
  startTime =  millis(); //設定程式開始執行的時間
  
}

void loop() {

  char runTime[7],realTimeStr[9],lastTimeStr[9];
  char luxStr[5],volStr[3];
  int counter;
  
  delay(500);
  
  dayTypeSet();
  readLastBootDate();
  
  lcd.setCursor ( 12, 1 );
  lcd.print( dayTypeR );
  lcd.setCursor ( 5, 1 );
  lcd.print(lastPressTimeStr);
  Serial.print("P2=");
  Serial.println( pcf8574.digitalRead(P2) );
  Serial.print("P0=");
  Serial.println( pcf8574.digitalRead(P0) );
  Serial.print("P1=");
  Serial.println( pcf8574.digitalRead(P1) );
  Serial.print("D6=");
  Serial.println( digitalRead(6) );  
  Serial.print("D2=");
  Serial.println( digitalRead(2) );
  Serial.print("A2= "); 
  Serial.println(analogRead(A2));     
  voiceNum = map(analogRead(A2), 137, 1023, 0, 30);    //旋鈕控制音量
  myDFPlayer.volume(voiceNum);
  
  Serial.println(dayTypeDIP1);
  Serial.println(dayTypeDIP2);
  Serial.println(dayTypeDIP3);
  Serial.println(dayTypeDIP4);
  Serial.print("dayType= ");
  Serial.println(dayType);
  if( minute() == 0 || minute() == 30)         //每整點與30分鐘判斷是否提醒
  {
    Serial.print("second= ");
    Serial.println(second());
    if(dayTypeDIP1 == 1)    //提醒早上吃藥
    {
     if(dayType == '1')
     {
        if( dayTypeR != '1' )
          if( (second() ==  0 ) && ( (hour()>= 6) && (hour()<=8)))
             if( (hour() != 8 ) && (minute() != 30))
               myDFPlayer.playMp3Folder(10); 
     }
     else if( ( dayTypeR != '1' ) && ( hour() == 9))
            msgToIFTTT("%E9%95%B7%E8%BC%A9%E5%BF%98%E8%A8%98%E5%90%83%E8%97%A5%2C%E8%A8%98%E5%BE%97%E6%8F%90%E9%86%92%E4%BB%96");   
    }  
    if(dayTypeDIP2 == 1)       //提醒中午吃藥
    {
     if(dayType == '2')
     {
        if( dayTypeR != '2' )
          if( (second() ==  0 ) && ( (hour()>= 11) && (hour()<=13)))
            if( (hour() != 13 ) && (minute() != 30))
               myDFPlayer.playMp3Folder(11); 
     }
     else if( ( dayTypeR != '2' ) && ( hour() == 14))
            msgToIFTTT("%E9%95%B7%E8%BC%A9%E5%BF%98%E8%A8%98%E5%90%83%E8%97%A5%2C%E8%A8%98%E5%BE%97%E6%8F%90%E9%86%92%E4%BB%96");
    }
    if(dayTypeDIP3 == 1)       //提醒晚上吃藥
    {
     if(dayType == '3')
     {
        if( dayTypeR != '3' )
          if( (second() ==  0 ) && ( (hour()>= 17) && (hour()<=19)))
            if( (hour() != 19 ) && (minute() != 30))
               myDFPlayer.playMp3Folder(12); 
     }
     else if( ( dayTypeR != '3' ) && ( hour() == 20))
            msgToIFTTT("%E9%95%B7%E8%BC%A9%E5%BF%98%E8%A8%98%E5%90%83%E8%97%A5%2C%E8%A8%98%E5%BE%97%E6%8F%90%E9%86%92%E4%BB%96");     
    }
    if(dayTypeDIP4 == 1)      //提醒睡前吃藥
    {
     if(dayType == '4')
     {
        if( dayTypeR != '4' )
        {
          if( (second() ==  0 ) && ( (hour()>= 21) && (hour()<=23)))
            if( (hour() != 23 ) && (minute() != 30))
               myDFPlayer.playMp3Folder(13); 
        }  
     }
     else if( ( dayTypeR != '4' ) && ( hour() == 0))
            msgToIFTTT("%E9%95%B7%E8%BC%A9%E5%BF%98%E8%A8%98%E5%90%83%E8%97%A5%2C%E8%A8%98%E5%BE%97%E6%8F%90%E9%86%92%E4%BB%96");     
    }
  }            
  lcd.setCursor ( 14, 1 );
  sprintf(volStr,"%02d",(int)voiceNum);
  lcd.print(volStr);
  lcd.setCursor ( 0, 0 );
  lcd.print(" now:");
  lcd.setCursor ( 0, 1 );
  lcd.print("1ast:");
  lcd.setCursor ( 5, 0 );
  sprintf(realTimeStr,"%02d:%02d:%02d   ",hour(),minute(),second());
  lcd.print(realTimeStr);
  if((pcf8574.digitalRead(P0) == 1) || (digitalRead(2) == 1))   //按下 綠色按鈕或是無線按鈕,告知系統已經吃藥了
  {
     lcd.setCursor ( 5, 1 );
     sprintf(lastTimeStr,"%02d:%02d  ",hour(),minute());
     lcd.print(lastTimeStr);
          
     myDFPlayer.playMp3Folder(4);
     playKey = !playKey ;
     playCounter =1 ;
     //connectNetwork();
        msgToIFTTT("%E6%88%91%E5%B7%B2%E7%B6%93%E5%90%83%E8%97%A5%E4%BA%86");
     savePressTime();
  }
  if(pcf8574.digitalRead(P1) == 1)         //按下黃色按鈕,查詢上次吃藥時間
  {
     switch( dayTypeR )
     {
         case '1' :
                   
                   myDFPlayer.playMp3Folder(5);  //上次吃藥是早上
                   playKey = !playKey ;
                   playCounter =1 ;
                   break;
         case '2' :
                   
                   myDFPlayer.playMp3Folder(6);  //上次吃藥是中午
                   playKey = !playKey ;
                   playCounter =1 ;
                   break; 
         case '3' :
                   myDFPlayer.playMp3Folder(7);  //上次吃藥是晚上
                   playKey = !playKey ;
                   playCounter =1 ;
                   break; 
         case '4' :
                   myDFPlayer.playMp3Folder(8);  //上次吃藥是睡前
                   playKey = !playKey ;
                   playCounter =1 ;
                   break;                                                       
     }
  }
  if(pcf8574.digitalRead(P2) == 1)              //紅色按鈕  告知家人藥已經快沒了,幫忙掛號
  {
       
    myDFPlayer.playMp3Folder(9);
    playKey = !playKey ;
    playCounter =1 ;
    //connectNetwork();
      msgToIFTTT("%E8%97%A5%E5%B7%B2%E7%B6%93%E5%BF%AB%E6%B2%92%E4%BA%86%E8%AB%8B%E5%B9%AB%E6%88%91%E6%8E%9B%E8%99%9F%E6%8B%BF%E8%97%A5%E8%AC%9D%E8%AC%9D");
    
  }  
  if(digitalRead(6)== 0)                        //藍色按鈕  播放歌曲 MP3歌曲
  {
    if( playCounter == 1)
    {
      
      myDFPlayer.enableLoopAll();               //micro SD root 下的檔案
      myDFPlayer.start();
      
      
      playCounter++ ;
    }
    playKey = !playKey ;                        // 再按一下藍色音樂暫停
    if( playKey )
        myDFPlayer.start();
    else
        myDFPlayer.pause();
    playMp3Flag = 1;
  }
  Serial.print("CurrentFileNumber= ");
  Serial.println(myDFPlayer.readCurrentFileNumber());
} 
 
/*-------- NTP code ----------*/

const int NTP_PACKET_SIZE = 48; // NTP time is in the first 48 bytes of message
byte packetBuffer[NTP_PACKET_SIZE]; //buffer to hold incoming & outgoing packets

time_t getNtpTime()
{
  Serial.println("Transmit NTP Request");
  Udp.setRecvTimeout(1500);
  sendNTPpacket();
  if ( Udp.read(packetBuffer, NTP_PACKET_SIZE) > 0 ) {
      unsigned long secsSince1900;
      // convert four bytes starting at location 40 to a long integer
      secsSince1900 =  (unsigned long)packetBuffer[40] << 24;
      secsSince1900 |= (unsigned long)packetBuffer[41] << 16;
      secsSince1900 |= (unsigned long)packetBuffer[42] << 8;
      secsSince1900 |= (unsigned long)packetBuffer[43];
      return secsSince1900 - 2208988800UL + timeZone * SECS_PER_HOUR;
  } else {                  
    // 無法取得NTP,再重新聯網試試,讓網路隨時保持連線狀態;網路閒置2-3分鐘,便會進入省電或休眠模式,就會造成無法連網,雖然 WL_CONNECTED == Ture
    Serial.println("No NTP Response :-(");
    wdt_enable(8000);
    wdt_reset();
    status = WiFi.begin(ssid1, pass1);
    delay(1000);
    wdt_reset();
    if(status != WL_CONNECTED)
      status = WiFi.begin(ssid2, pass2); 
    wdt_disable();
    return 0; // return 0 if unable to get the time
  }
}

// send an NTP request to the time server at the given address
// send an NTP request to the time server at the given address
void sendNTPpacket()
{
  // set all bytes in the buffer to 0
  memset(packetBuffer, 0, NTP_PACKET_SIZE);
  // Initialize values needed to form NTP request
  // (see URL above for details on the packets)
  packetBuffer[0] = 0b11100011;   // LI, Version, Mode
  packetBuffer[1] = 0;     // Stratum, or type of clock
  packetBuffer[2] = 6;     // Polling Interval
  packetBuffer[3] = 0xEC;  // Peer Clock Precision
  // 8 bytes of zero for Root Delay & Root Dispersion
  packetBuffer[12]  = 49;
  packetBuffer[13]  = 0x4E;
  packetBuffer[14]  = 49;
  packetBuffer[15]  = 52;
  // all NTP fields have been given values, now
  // you can send a packet requesting a timestamp:                 
  Udp.beginPacket(timeServer, 123); //NTP requests are to port 123
  Udp.write(packetBuffer, NTP_PACKET_SIZE);
  Udp.endPacket();
}

void msgToIFTTT(String msgStr)
{
   client.stop();
   if (!client.connect(iftttHost, 80)) {
     Serial.println("connection failed");
     return;
   }
 
     String url = "/trigger/";  //組合觸發網址
     url += eventName;
     url += "/with/key/";
     url += key;
     url += "?value1=";
     url += msgStr;
     Serial.print("Requesting URL: ");
     Serial.println(url);
     
     client.print(String("GET ") + url + " HTTP/1.1\r\n" +
                  "Host: " + iftttHost + "\r\n" + 
                  "Connection: close\r\n\r\n");
     int timeout = millis() + 5000;
     while (client.available() == 0) {
       if (timeout - millis() < 0) {
         Serial.println("Client Timeout !");
         client.stop();
         //myDFPlayer.play(10);     //系統連線失敗
         return;
       }
     }
     
     while(client.available()){  //顯示回應訊息
       String line = client.readStringUntil('\r');
       Serial.print(line);
     }
   
}

void printDetail(uint8_t type, int value){
  switch (type) {
    case TimeOut:
      Serial.println(F("Time Out!"));
      break;
    case WrongStack:
      Serial.println(F("Stack Wrong!"));
      break;
    case DFPlayerCardInserted:
      Serial.println(F("Card Inserted!"));
      break;
    case DFPlayerCardRemoved:
      Serial.println(F("Card Removed!"));
      break;
    case DFPlayerCardOnline:
      Serial.println(F("Card Online!"));
      break;
    case DFPlayerUSBInserted:
      Serial.println("USB Inserted!");
      break;
    case DFPlayerUSBRemoved:
      Serial.println("USB Removed!");
      break;
    case DFPlayerPlayFinished:
      Serial.print(F("Number:"));
      Serial.print(value);
      Serial.println(F(" Play Finished!"));
      break;
    case DFPlayerError:
      Serial.print(F("DFPlayerError:"));
      switch (value) {
        case Busy:
          Serial.println(F("Card not found"));
          break;
        case Sleeping:
          Serial.println(F("Sleeping"));
          break;
        case SerialWrongStack:
          Serial.println(F("Get Wrong Stack"));
          break;
        case CheckSumNotMatch:
          Serial.println(F("Check Sum Not Match"));
          break;
        case FileIndexOut:
          Serial.println(F("File Index Out of Bound"));
          break;
        case FileMismatch:
          Serial.println(F("Cannot Find File"));
          break;
        case Advertise:
          Serial.println(F("In Advertise"));
          break;
        default:
          break;
      }
      break;
    default:
      break;
  }
  
}

void post(String IDEASCHAIN_DID, String IDEASCHAIN_AK, String IDEASCHAIN_SID, String value){  //  ��ƤW�ǥ��x
 client.stop();
 if (client.connect("ideaschain.com.tw", 80)) {
    client.print("POST /iot/v1/rawdata/");
    client.print(IDEASCHAIN_DID);
    client.println(" HTTP/1.1");
    client.println("Host: ideaschain.com.tw");
    client.print("AK: ");
    client.println(IDEASCHAIN_AK);    
    client.println("Content-Type: application/json");  ;
    client.print("Content-Length: ");
    client.println(IDEASCHAIN_SID.length()+value.length()+25);
    client.println();
    client.print("[{\"sid\":\"");
    client.print(IDEASCHAIN_SID);
    client.print("\",\"value\":[\"");
    client.print(value);
    client.println("\"]}]");
    } else {
      Serial.println();
      Serial.println("disconnecting from server.");
      //myDFPlayer.play(10);     //系統連線失敗
    }
    delay(500);
    Serial.println("sendData end");
}

 
void getJsonData(String IDEASCHAIN_DID, String IDEASCHAIN_AK){  //  資料下載
  
 String jsonTmp ; 
 client.stop();
 
 if (client.connect("ideaschain.com.tw", 80)) {
  // We now create a URI for the request
      String url = "/iot/v1/rawdata/" + IDEASCHAIN_DID;
      // This will send the request to the server
      client.print("GET " + url + " HTTP/1.1\r\n" +
                   "Host: " + "ideaschain.com.tw" + "\r\n" +
                   "AK:"+ IDEASCHAIN_AK + "\r\n" +
                   "Content-Type: application/json\r\n" + 
                   "Connection: close\r\n\r\n");
      delay(500);
    //取資料印出來
      while(client.available())
      {
        while(client.available()) {
          char c = client.read();
          while( c == '[' ){
            while (client.available()) {
              c = client.read();
              jsonTmp += c;
            }
          }
        }
      String jsonData = '[' + jsonTmp;
      
      Serial.println(jsonData); 
      DeserializationError error = deserializeJson(doc, jsonData);

      // Test if parsing succeeds.
       if (error) {
         Serial.print(F("deserializeJson() failed: "));
         Serial.println(error.c_str());
         return;
        }
       JsonArray array = doc.as<JsonArray>();
       for(JsonVariant v : array) {
         //Serial.println(v.as<int>());
          const char* sid2 = v["sid"];
          double value2 = v["value"][0];
          Serial.print(sid2);
          Serial.print("=");
          Serial.println(value2);
        }      
        
          getRFAValue = doc[0]["value"][0];

      }

    } else {
      Serial.println();
      Serial.println("disconnecting from server.");
      //myDFPlayer.play(10);     //系統連線失敗
    }
    
    Serial.println("getJsonData end");
   // return value;
}

void savePressTime()
{
  String str ;

  sprintf(now_Str,"%2d:%02d%c",hour(),minute(),dayType);
  
  FlashMemory.read();
 
  
  for(int i= 0; i< 5 ;i++)
    FlashMemory.buf[i] = now_Str[i];
  FlashMemory.buf[5] = dayType ;
  FlashMemory.update();
   
}

void dayTypeSet()
{
  if( hour() >= 0 && hour() < 11 )
     dayType = '1';
  if( hour() >= 11 && hour() < 18 )
     dayType = '2';    
  if( hour() >= 18 && hour() < 21 )
     dayType = '3';     
  if( hour() >= 21 && hour() <= 23 )
     dayType = '4';   
}

void readLastBootDate()
{
    lastPressTimeStr = "";
    FlashMemory.read();
    for(int i=0;i<5;i++)
    {
      lastPressTimeStr = lastPressTimeStr + char(FlashMemory.buf[i]);
    }
    dayTypeR = char(FlashMemory.buf[5]);
}

void connectNetwork()
{
        
  // attempt to connect to Wifi network:
  

     wdt_enable(8000);
     wdt_reset();
     status = WiFi.begin(ssid1, pass1);
     delay(1000);
     
     wdt_reset();
     if(status != WL_CONNECTED)
        status = WiFi.begin(ssid2, pass2); 
     //systemStartTime = millis();
     wdt_disable();
  
  


}
