#include <WiFi.h>                   //WIFI library
#include <PubSubClient.h>           //MQTT library

#define Do  523
#define Re  587
#define Mi  659
#define Fa  698
#define So  784
#define La  880
#define Si  988
int melody= Mi;

float vOUT = 0.0;
float vIN = 0.0;
float R1 = 30000.0;
float R2 = 7500.0;
float alarm =0;
int value = 0;

int voltage = A2;
int LED = 11;
int buzzer = 12;
int button = 13;

char ssid[] = "NEAF605";          // SSID:router name
char pass[] = "33730605";           // pass:router password
int status  = WL_IDLE_STATUS;       // keep connecting
char mqttServer[]     = "iiot.ideaschain.com.tw";          // take ideaschain as server
int  mqttPort         = 1883;
char clientId[]       = "";  // MQTT client ID. Create an unique ID.
char username[]       = "05LpMnarUJABck35Wg6X";      // device access token(change your own access token of IDEASChain)
char password[]       = "";                                // don't need to set up
char subscribeTopic[] = "v1/devices/me/telemetry";         //fixed topic, do not modify
char publishTopic[]   = "v1/devices/me/telemetry";         //as the same as subscribeTopic
String payload_string;
char publishTopicStr1[] = "vIN";
char publishTopicStr2[] = "alarm";
char publishPayload[] = "{\"vIN\":\"20\",\"alarm\":\"20\"}";

WiFiSSLClient client1;

void callback(char *topic, byte *payload, unsigned int length) {//recept the data from server
  Serial.print("Message arrived in topic: ");
  Serial.println(topic);
  Serial.print("Message:");
  for (int i = 0; i < length; i++) {
    Serial.print( (char) payload[i]);                 // convert *byte to string
  }

  Serial.println();
  Serial.println("-----------------------------------");
}

WiFiClient wifiClient;
PubSubClient client(wifiClient);                                //define the client's name

void publishData( char*publishTopicStr, float sensorValue) {

  char sensorDist [30];
  sprintf (sensorDist , "{\"%s \":\"%.2f \"}", publishTopicStr, sensorValue);
  Serial.println(sensorDist);

  while (!client.connected()) {
    Serial.println("Attempting MQTT connection Attempt to connect...");
    if (client.connect (clientId, username, password)) {
      Serial.println("MQTT connected");
      client.publish(publishTopic, sensorDist);
      client.subscribe(subscribeTopic);
    }
    else {
      Serial.print("failed rc= ");
      Serial.print(client.state());
      Serial.println("try again in 5 seconds ");
      delay(5000);
    }
  }
}

void reconnect() {                            // client connect to the MQTT server

  while (!client.connected()) {                             //while(disconnect),then run the loop continually
    Serial.println("Attempting MQTT connection...");
    if (client.connect(clientId, username, password)) {     // try to connect
      Serial.println("MQTT connected");                     //after connected, publish the topic & payload
      client.publish(publishTopic, "payload_string");
      client.subscribe(subscribeTopic);                     //resubscribe the topic
    } else {
      Serial.print("failed, rc=");
      Serial.print(client.state());
      Serial.println(" try again in 5 seconds");
      delay(5000);                                          //wating for 5 second to reconnect
    }
  }
}

void printWifiData() {
  IPAddress ip = WiFi.localIP();
  Serial.print("IP Address: ");
  Serial.println(ip);
}

void setup() {
  Serial.begin(9600); // 設定Serial 傳輸速度

  pinMode(LED,      OUTPUT);
  pinMode(buzzer,   OUTPUT);
  pinMode(button,   INPUT);
  digitalWrite(LED, LOW);

  while (status != WL_CONNECTED) {
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(ssid);
    // Connect to WPA/WPA2 network. Change this line if using open or WEP network:
    status = WiFi.begin(ssid, pass);
    //if()
    
    // wait 10 seconds for connection:
    delay(10000);
  }

  printWifiData();

  client.setServer(mqttServer, mqttPort);
  client.setCallback(callback);

  // Allow the hardware to sort itself out
  delay(1500);
}

void loop() 
{
  value = analogRead(voltage);
  vOUT = (value * 5.0) / 1024.0;
  vIN = vOUT / (R2/(R1+R2)) - 5.1;
  
  Serial.print("Input = ");
  Serial.print(vIN);
  Serial.println(" V");

  alarm = digitalRead(button);

  if (!client.connected()) {
    reconnect();
    delay(2000);
  }

  client.disconnect();
  client.loop();
  delay(300);
  publishData(publishTopicStr2,alarm);
  client.disconnect();
  client.loop();
  delay(300);  
  publishData(publishTopicStr1,vIN);

  if(digitalRead(button) == HIGH)
  {
  client.disconnect();
  client.loop();
  delay(300);
  publishData(publishTopicStr2,alarm);

  //加上電池電壓IF
  
  Serial.println("alarm");
  digitalWrite(LED, HIGH);
    while(true)
    {
    tone(buzzer, melody);
    }
  }
  delay(1000);
}
