//#include <SPI.h>
#include <WiFi.h>
#include <WiFiUdp.h>
#include <HttpClient.h>
#include <PubSubClient.h>
#include <Wire.h>
#include <TimeLib.h>
#include <ArduinoJson.h>
#include "SoftwareSerial.h"
#include "DFRobotDFPlayerMini.h"
//#include <Adafruit_GFX.h>
//#include <Adafruit_SSD1306.h>
#include <U8g2lib.h>




int weatherKind;
U8G2_SSD1306_128X64_NONAME_F_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE);

//------------------------------ WPA/WPA2 SSID and password-------------------------------
char ssid[] = "Pos";      // your network SSID (name)
char pass[] = "0222435183";  // your network password
int status  = WL_IDLE_STATUS;   // the Wifi radio's status

//----------------------------- openweathermap----------------------------------
//open weather map api key
String apiKey = "b3a1fd4de2403e47a564135a5be59821";
//the city you want the weather for
String location = "Taipei,TW";  // Tainan,Kaohsiung,Taoyuan,Hsinchu,Taichung,Keelung
char server[] = "api.openweathermap.org";
//-----------------------------------------------------------------------------------------------------------
char mqttServer[]     = "iiot.ideaschain.com.tw";  // new ideaschain dashboard MQTT server
int mqttPort          = 1883;
char clientId[]       = "DSI5168Test";            // MQTT client ID. it's better to use unique id.
char username[]       = "6ee85EfXy5Ud7otVtULk";    // device access token(存取權杖)
char password[]       = "";                        // no need password
char subscribeTopic[] = "v1/devices/me/telemetry";
char publishTopic[]   = "v1/devices/me/telemetry";  // Fixed topic. ***DO NOT MODIFY***
char subscribeTopicRPC[] = "v1/devices/me/rpc/request/+";  // RPC MQTT
char publishPayload[] = "{\"ForeheadTemp\":\"30\"}";        // String of stringified JSON Object (key value pairs)

#define MQTT_RECONNECT_INTERVAL 100                   // millisecond
#define MQTT_LOOP_INTERVAL      50                    // millisecond


//-------------------------------- NTP Server setup---------------------------------------------------------
int keyIndex = 0;                                   // your network key Index number (needed only for WEP)
char timeServer[] = "time.stdtime.gov.tw";
const int timeZone = 8;                             // Taipei Time
// A UDP instance to let us send and receive packets over UDP
WiFiUDP Udp;
unsigned int localPort = 2390;                      // local port to listen for UDP packets
time_t getNtpTime();
void sendNTPpacket(IPAddress &address);
//------------------------------------MQTT Setup---------------------------------
void mqtt_callback(char* topic, byte* payload, unsigned int msgLength);  // MQTT Callback function header
WiFiClient wifiClient;
PubSubClient mqttClient(mqttServer, mqttPort, mqtt_callback, wifiClient);
//PubSubClient client(wifiClient);
unsigned long startTime, nowTime;  // 程式起始時間與目前時間
unsigned long WifiConnectingTimeout; //連線逾時時間


#define SCREEN_WIDTH 128 // OLED 寬度像素
#define SCREEN_HEIGHT 64 // OLED 高度像素
#define NUMFLAKES 10
#define XPOS 0
#define YPOS 1
#define DELTAY 2
#define LOGO16_GLCD_HEIGHT 16
#define LOGO16_GLCD_WIDTH  16
// 設定OLED
#define OLED_RESET     0 // Reset pin # (or -1 if sharing Arduino reset pin)
//Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);

SoftwareSerial mySoftwareSerial(0, 1); // RX, TX
DFRobotDFPlayerMini myDFPlayer;

void printDetail(uint8_t type, int value);


PubSubClient client(wifiClient);
WiFiSSLClient SSLclient;

char *weekdayStr[7] = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
int alarmVoice = 0  , voiceNum;
char now_Str[7];
char dayType = '1', dayTypeR = '1';
int currentMp3 = 2 , playKey = 0 , playCounter = 1, playMp3Flag = 0 ;
String weatherFlag;
unsigned long weatherTimeoutStart;
int weatherTimeoutCounter = 0;
String weatherStr, nowTemp, maxTemp, minTemp;
int startClassFlag;

//------------------------------json6 object-------------------------------------------------------------
StaticJsonDocument<5000> doc;
char json_output[100];
long lastTime = 0;

boolean mqtt_nonblock_reconnect() {
  boolean doConn = false;

  if (! mqttClient.connected()) {
    // attempts to reconnect every [MQTT_RECONNECT_INTERVAL] milliseconds without blocking the main loop.
    long currTime = millis();
    if (currTime - lastTime > MQTT_RECONNECT_INTERVAL) {
      lastTime = currTime;
      doConn = true;
      //boolean isConn = mqttClient.connect(clientId);
      boolean isConn = mqttClient.connect(clientId, username, password);
      char logConnected[100];
      sprintf(logConnected, "MQTT System [%s] Connect %s !", clientId, (isConn ? "Successful" : "Failed"));
      Serial.println(logConnected);

      if (isConn) {

        mqttClient.subscribe(subscribeTopic);
        mqttClient.subscribe(subscribeTopicRPC);

      }
    }
  }

}

void mqtt_callback(char* topic, byte* payload, unsigned int msgLength) {

  char temp[80];
  sprintf(temp , "Message arrived with Topic [%s]\n  Data Length: [%d], Payload: [", topic, msgLength);
  Serial.print(temp);
  Serial.write(payload, msgLength);
  Serial.println("]");

  /*if (strcmp(MQTT_SUBSCRIBE_AREA, topic) == 0) {                 // Topic: [HomeDevice/Button]

      String aresStr  = "";
      for (int i = 0; i < msgLength; i++) {
        aresStr += (char)payload[i];
      }      //  Payload: [On]


    }*/
}

void setup()
{

  pinMode(13, OUTPUT);
  Serial.begin(9600);
  mySoftwareSerial.begin(9600);


  Serial.println("Connected to wifi");
  delay(2000);

  u8g2.begin();
  u8g2.enableUTF8Print();

  u8g2.setFont(u8g2_font_unifont_t_chinese1); //使用我們做好的字型
  u8g2.clearBuffer();
  u8g2.setCursor(10, 30);
  u8g2.print("物聯網智造基地");
  u8g2.setCursor(5, 50);
  u8g2.print("IOT SERVICE HUB");
  u8g2.sendBuffer();



  if (!myDFPlayer.begin(mySoftwareSerial)) {  //Use softwareSerial to communicate with mp3.
    Serial.println(F("Unable to begin:"));
    Serial.println(F("1.Please recheck the connection!"));
    Serial.println(F("2.Please insert the SD card!"));
    while (true) {
      delay(0); // Code to compatible with ESP8266 watch dog.
    }
  }
  Serial.println(F("DFPlayer Mini online."));

  myDFPlayer.EQ(DFPLAYER_EQ_ROCK);
  myDFPlayer.volume(25);
  myDFPlayer.playMp3Folder(1);     //系統設定中



  if (WiFi.status() == WL_NO_SHIELD) {
    Serial.println("WiFi shield not present");
    // don't continue:
    while (true);
  }

  WifiConnectingTimeout = millis();
  WiFi.begin(ssid, pass);
  while (WiFi.status() != WL_CONNECTED) {
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(ssid);

    // Connect to WPA/WPA2 network. Change this line if using open or WEP network:

    Serial.println("Connect ...");

    if ((millis() - WifiConnectingTimeout) > 10000)   //等待超過 10秒
      break;
    // wait 3 seconds for connection:
    delay(3000);
  }

  Serial.println(WiFi.localIP());

  if (WiFi.status() == WL_CONNECTED )
  {
    myDFPlayer.playMp3Folder(2);           //MP3資料夾下的 0002.mp3 連線完成
    Serial.println("waiting for sync");
    Udp.begin(localPort);
    getNtpTime();
    delay(2000);
    setSyncProvider(getNtpTime);          //每120秒同步 NTP 時間
    setSyncInterval(120);

    int getLoop = 0;
    while ( nowTemp.toInt() == 0 )
    {
      ++getLoop ;
      getWeather();
      if ( getLoop > 5)
      {
        Serial.println("getWeather error!!");
        break ;
      }
    }
  }
  else
  {
    Serial.println("no network !!   ");
    myDFPlayer.playMp3Folder(3);    //MP3資料夾下的 0003.mp3  系統連線失敗

  }

  displayInstruction();
  myDFPlayer.playMp3Folder(4010);
  delay(9000);


  myDFPlayer.playMp3Folder(4020);
  delay(2000);
  mqttClient.setServer(mqttServer, mqttPort);
  mqttClient.setCallback(mqtt_callback);
  startTime =  millis();
}


void loop()
{

  String Buff   ;
  StaticJsonDocument<200> json_doc ;

  mqtt_nonblock_reconnect();

  Serial.print("D13: ");
  Serial.println(digitalRead(13));
  if ( digitalRead(13))
  {
    startClassFlag = 1;
    myDFPlayer.playMp3Folder(4030);
    delay(2000);

  }
  if ((minute() == 29 || minute() == 0 )  && second() == 0  )
  {
    getNtpTime();
    getWeather();
    while ( (nowTemp.toInt() == 0) && (WiFi.status() == WL_CONNECTED) )
      getWeather();
  }
  if ( weekday() != 1 || weekday() != 7)
  {
    if ( hour() == 8 && minute() == 45 && second() == 0 )
    {

      if ( minute() > 50 )           //上課超過5分鐘未按鈕
      {
        if ( !startClassFlag )
        {
          Buff = "";
          Buff += "1" ;              //標記第一堂課未上課
          json_doc["Absent"] = Buff;
          serializeJson(json_doc, json_output);
          mqttClient.publish(publishTopic, json_output);
        }
      }
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第一堂上課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("8:45-9:25");
      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4021);
      delay(2000);
      myDFPlayer.playMp3Folder(4038);
      delay(16000);
    }
    if ( hour() == 9 && minute() == 25 && second() == 0 )
    {
      startClassFlag = 0 ;
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第一堂下課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("9:25-9:35");
      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4031);
      delay(2000);
      myDFPlayer.playMp3Folder(4039);
      delay(16000);
    }
    if ( hour() == 9 && minute() == 35 && second() == 0 )
    {
      if ( minute() > 40 )           //上課超過5分鐘未按鈕
      {
        if ( !startClassFlag )
        {
          Buff = "";
          Buff += "2" ;              //標記第二堂課未上課
          json_doc["Absent"] = Buff;
          serializeJson(json_doc, json_output);
          mqttClient.publish(publishTopic, json_output);
          
        }
      }u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第二堂上課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("9:35-10:15");
      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4022);
      delay(2000);
      myDFPlayer.playMp3Folder(4038);
      delay(16000);
    }
    if ( hour() == 10 && minute() == 15 && second() == 0 )
    {
      startClassFlag = 0 ;
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第二堂下課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("10:15-10:35");

      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4032);
      delay(2000);
      myDFPlayer.playMp3Folder(4039);
      delay(16000);
    }
    if ( hour() == 10 && minute() == 35 && second() == 0 )
    {
      if ( minute() > 50 )           //上課超過5分鐘未按鈕
      {
        if ( !startClassFlag )
        {
          Buff = "";
          Buff += "3" ;              //標記第三堂課未上課
          json_doc["Absent"] = Buff;
          serializeJson(json_doc, json_output);
          mqttClient.publish(publishTopic, json_output);
        }
      }      
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第三堂上課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("10:35-11:15");
      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4023);
      delay(2000);
      myDFPlayer.playMp3Folder(4038);
      delay(16000);
    }
    if ( hour() == 11 && minute() == 15 && second() == 0 )
    {
      startClassFlag = 0 ;
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第三堂下課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("11:15-11:25");

      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4033);
      delay(2000);
      myDFPlayer.playMp3Folder(4039);
      delay(16000);
    }
    if ( hour() == 11 && minute() == 25 && second() == 0 )
    {
      if ( minute() > 30 )           //上課超過5分鐘未按鈕
      {
        if ( !startClassFlag )
        {
          Buff = "";
          Buff += "4" ;              //標記第四堂課未上課
          json_doc["Absent"] = Buff;
          serializeJson(json_doc, json_output);
          mqttClient.publish(publishTopic, json_output);
        }
      }      
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第四堂上課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("11:25-12:05");
      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4024);
      delay(2000);
      myDFPlayer.playMp3Folder(4038);
      delay(16000);
    }
    if ( hour() == 12 && minute() == 5 && second() == 0 )
    {
      startClassFlag = 0 ;
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第四堂下課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("12:05-13:20");

      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4034);
      delay(2000);
      myDFPlayer.playMp3Folder(4039);
      delay(16000);
    }
    if ( hour() == 13 && minute() == 30 && second() == 0 )
    {
      if ( minute() > 35 )           //上課超過5分鐘未按鈕
      {
        if ( !startClassFlag )
        {
          Buff = "";
          Buff += "5" ;              //標記第五堂課未上課
          json_doc["Absent"] = Buff;
          serializeJson(json_doc, json_output);
          mqttClient.publish(publishTopic, json_output);
        }
      }
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第五堂上課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("13:30-14:10");
      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4025);
      delay(2000);
      myDFPlayer.playMp3Folder(4038);
      delay(16000);
    }
    if ( hour() == 14 && minute() == 10 && second() == 0 )
    {
      startClassFlag = 0 ;
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第五堂下課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("14:10-14:20");

      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4035);
      delay(2000);
      myDFPlayer.playMp3Folder(4039);
      delay(16000);
    }
    if ( hour() == 14 && minute() == 20 && second() == 0 )
    {
      if ( minute() > 25 )           //上課超過5分鐘未按鈕
      {
        if ( !startClassFlag )
        {
          Buff = "";
          Buff += "6" ;              //標記第六堂課未上課
          json_doc["Absent"] = Buff;
          serializeJson(json_doc, json_output);
          mqttClient.publish(publishTopic, json_output);
        }
      }
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第六堂上課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("14:20-15:00");
      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4026);
      delay(2000);
      myDFPlayer.playMp3Folder(4038);
      delay(16000);
    }
    if ( hour() == 15 && minute() == 0 && second() == 0 )
    {
      startClassFlag = 0 ;
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第六堂下課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("15:00-15:20");

      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4036);
      delay(2000);
      myDFPlayer.playMp3Folder(4039);
      delay(16000);
    }
    if ( hour() == 15 && minute() == 20 && second() == 0 )
    {
      if ( minute() > 25 )           //上課超過5分鐘未按鈕
      {
        if ( !startClassFlag )
        {
          Buff = "";
          Buff += "7" ;              //標記第七堂課未上課
          json_doc["Absent"] = Buff;
          serializeJson(json_doc, json_output);
          mqttClient.publish(publishTopic, json_output);
        }
      }
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第七堂上課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("15:20-16:00");
      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4026);
      delay(2000);
      myDFPlayer.playMp3Folder(4038);
      delay(16000);
    }
    if ( hour() == 16 && minute() == 0 && second() == 0 )
    {
      startClassFlag = 0 ;
      u8g2.clearBuffer();
      u8g2.setCursor(10, 16);
      u8g2.print("第七堂下課時間:");
      u8g2.setCursor(10, 36);
      u8g2.print("16:00-16:10");

      u8g2.sendBuffer();
      myDFPlayer.playMp3Folder(4037);
      delay(2000);
      myDFPlayer.playMp3Folder(4039);
      delay(16000);
    }
    if ( ((hour() >= 16) || (hour() < 8)) )
    {
      u8g2.clearBuffer();
      u8g2.setCursor(10, 36);
      u8g2.print("Take Break...");
      u8g2.sendBuffer();
    }
  }
  mqttClient.loop();
  delay(50);
}

void displayInstruction()      //系統開始執行時,呈現的資訊
{

  u8g2.clearBuffer();
  u8g2.setCursor(10, 16);
  u8g2.print("這是個在家學習時");
  u8g2.setCursor(10, 36);
  u8g2.print("間管理系統,會按");
  u8g2.setCursor(10, 56);
  u8g2.print("時間播報上下課鐘聲");
  u8g2.sendBuffer();
}



/*-------- NTP code ----------*/

const int NTP_PACKET_SIZE = 48; // NTP time is in the first 48 bytes of message
byte packetBuffer[NTP_PACKET_SIZE]; //buffer to hold incoming & outgoing packets

time_t getNtpTime()
{
  Serial.println("Transmit NTP Request");
  Udp.setRecvTimeout(1500);
  sendNTPpacket();
  if ( Udp.read(packetBuffer, NTP_PACKET_SIZE) > 0 ) {
    unsigned long secsSince1900;
    // convert four bytes starting at location 40 to a long integer
    secsSince1900 =  (unsigned long)packetBuffer[40] << 24;
    secsSince1900 |= (unsigned long)packetBuffer[41] << 16;
    secsSince1900 |= (unsigned long)packetBuffer[42] << 8;
    secsSince1900 |= (unsigned long)packetBuffer[43];
    return secsSince1900 - 2208988800UL + timeZone * SECS_PER_HOUR;
  } else {
    // 無法取得NTP,再重新聯網試試,讓網路隨時保持連線狀態;網路閒置2-3分鐘,便會進入省電或休眠模式,就會造成無法連網,雖然 WL_CONNECTED == Ture
    Serial.println("No NTP Response :-(");
    wdt_enable(8000);
    wdt_reset();
    status = WiFi.begin(ssid, pass);
    delay(1000);
    wdt_reset();
    wdt_disable();
    return 0; // return 0 if unable to get the time
  }
}

// send an NTP request to the time server at the given address
// send an NTP request to the time server at the given address
void sendNTPpacket()
{
  // set all bytes in the buffer to 0
  memset(packetBuffer, 0, NTP_PACKET_SIZE);
  // Initialize values needed to form NTP request
  // (see URL above for details on the packets)
  packetBuffer[0] = 0b11100011;   // LI, Version, Mode
  packetBuffer[1] = 0;     // Stratum, or type of clock
  packetBuffer[2] = 6;     // Polling Interval
  packetBuffer[3] = 0xEC;  // Peer Clock Precision
  // 8 bytes of zero for Root Delay & Root Dispersion
  packetBuffer[12]  = 49;
  packetBuffer[13]  = 0x4E;
  packetBuffer[14]  = 49;
  packetBuffer[15]  = 52;
  // all NTP fields have been given values, now
  // you can send a packet requesting a timestamp:
  Udp.beginPacket(timeServer, 123); //NTP requests are to port 123
  Udp.write(packetBuffer, NTP_PACKET_SIZE);
  Udp.endPacket();
}

time_t getWeather() {              //取得氣象預報

  String jsonTmp ;
  wifiClient.stop();
  Serial.println("\nStarting connection to server...");
  // if you get a connection, report back via serial:
  if (wifiClient.connect(server, 80)) {
    Serial.println("connected to server");
    // Make a HTTP request:
    wifiClient.print("GET /data/2.5/weather?");
    wifiClient.print("q=" + location);
    wifiClient.print("&appid=" + apiKey);
    wifiClient.print("&cnt=3");
    wifiClient.println("&units=metric");
    wifiClient.println("Host: api.openweathermap.org");
    wifiClient.println("Connection: close");
    wifiClient.println();
    wifiClient.flush();
  } else {
    Serial.println("unable to connect");
  }

  delay(500);
  while (wifiClient.available())
  {

    String jsonData = wifiClient.readStringUntil('\r');  //逐列讀取
    Serial.println(jsonData);
    DeserializationError error = deserializeJson(doc, jsonData);

    // Test if parsing succeeds.
    if (error) {
      Serial.print(F("deserializeJson() failed: "));
      Serial.println(error.c_str());
      //return;
    }
    //JsonArray array = doc.as<JsonArray>();

    String Str1 = doc["main"]["temp"];
    String Str2 = doc["main"]["temp_min"];
    String Str3 = doc["main"]["temp_max"];
    String Str4 = doc["weather"][0]["main"];

    nowTemp = Str1;
    minTemp = Str2;
    maxTemp = Str3;
    weatherStr = Str4;

    Serial.print("目前溫度: ");
    Serial.println(nowTemp);
    Serial.print("最低溫度: ");
    Serial.println(minTemp);  //顯示溫度值
    Serial.print("最高溫度: ");
    Serial.println(maxTemp);  //顯示溫度值
    Serial.print("天氣狀況: ");
    Serial.println(weatherStr);
    if ( weatherStr == "Clear"  )
      weatherKind = 0;
    if ( weatherStr == "Clouds" )
      weatherKind = 2;
    if ( weatherStr == "Rain" )
      weatherKind = 3;
    if ( weatherStr == "Drizzle" )
      weatherKind = 3;
    if ( weatherStr == "Thunderstorm" )
      weatherKind = 4 ;

  }
}
