#include <Arduino.h>
#include <U8g2lib.h>

#ifdef U8X8_HAVE_HW_SPI
#include <SPI.h>
#endif
#ifdef U8X8_HAVE_HW_I2C
#include <Wire.h>
#endif

//------------ NodeMCU 上有 OLED 可以使用----------------------------------
//U8G2_SSD1306_128X64_NONAME_1_SW_I2C u8g2(U8G2_R0, /* clock=*/ 2, /* data=*/ 1, /* reset=*/ U8X8_PIN_NONE); 
//------------ ESP8266 , NodeMCU , DSI5168 都可以使用----------------------
U8G2_SSD1306_128X64_NONAME_1_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE);
//U8G2_SH1106_128X64_NONAME_1_HW_I2C u8g2(U8G2_R0, /* reset=*/ U8X8_PIN_NONE);


void setup(void) {
  u8g2.begin();
  u8g2.enableUTF8Print();  //啟用UTF8文字的功能  
}

void loop(void) {
  u8g2.setFont(u8g2_font_unifont_t_chinese1); //使用我們做好的字型
  u8g2.firstPage();
  do {
    u8g2.setCursor(0, 14);
    u8g2.print("日期: 2020/6/20");
    u8g2.setCursor(0, 30);
    u8g2.print("時間:14:00-17:00");
    u8g2.setCursor(0, 46);
    u8g2.print(" 大港自造學校");
    u8g2.setCursor(0, 61);
    u8g2.print("語音額溫槍量測儀");
  } while ( u8g2.nextPage() );
  delay(1000);
}
